/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.util.compound;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.fml.DistExecutor;

public class DynamicComponentUtil {

    public static class BreathColorfulText {
        public static Component getColorfulText(String textKey, @Nullable String append, int[] colors, int totalSteps, int durationMs, boolean isTranslatable) {
            return (Component)DistExecutor.unsafeRunForDist(() -> () -> BreathColorfulText.buildBreathText(textKey, append, colors, totalSteps, durationMs, isTranslatable), () -> () -> Component.m_237115_((String)textKey));
        }

        private static MutableComponent buildBreathText(String textKey, @Nullable String append, int[] colors, int totalSteps, int durationMs, boolean isTranslatable) {
            Preconditions.checkArgument((colors.length >= 1 ? 1 : 0) != 0, (Object)"\u81f3\u5c11\u9700\u8981\u6307\u5b9a\u4e00\u4e2a\u57fa\u7840\u989c\u8272");
            String fullText = BreathColorfulText.getLocalizedText(textKey, isTranslatable) + Optional.ofNullable(append).orElse("");
            int baseColor = colors[0];
            int[] breathColors = BreathColorfulText.generateRGBBreathWave(baseColor, totalSteps);
            long cyclePosition = System.currentTimeMillis() % (long)durationMs;
            int colorIndex = (int)(cyclePosition * (long)totalSteps / (long)durationMs) % totalSteps;
            if (colorIndex < 0 || colorIndex >= totalSteps) {
                colorIndex = 0;
            }
            return BreathColorfulText.buildColoredComponents(fullText, breathColors[colorIndex]);
        }

        private static String getLocalizedText(String key, boolean translatable) {
            return translatable ? Language.m_128107_().m_6834_(key) : key;
        }

        private static MutableComponent buildColoredComponents(String text, int color) {
            MutableComponent component = Component.m_237119_();
            TextColor textColor = TextColor.m_131266_((int)(color & 0xFFFFFF));
            for (char c : text.toCharArray()) {
                component.m_7220_((Component)Component.m_237113_((String)String.valueOf(c)).m_6270_(Style.f_131099_.m_131148_(textColor)));
            }
            return component;
        }

        private static int[] generateRGBBreathWave(int baseColor, int totalSteps) {
            int r = baseColor >> 16 & 0xFF;
            int g = baseColor >> 8 & 0xFF;
            int b = baseColor & 0xFF;
            int[] wave = new int[totalSteps];
            for (int i = 0; i < totalSteps; ++i) {
                float ratio = 0.8f * (float)Math.abs(Math.sin(Math.PI * (double)i / (double)totalSteps)) + 0.2f;
                int dr = BreathColorfulText.clamp((int)((float)r * ratio), 0, 255);
                int dg = BreathColorfulText.clamp((int)((float)g * ratio), 0, 255);
                int db = BreathColorfulText.clamp((int)((float)b * ratio), 0, 255);
                wave[i] = dr << 16 | dg << 8 | db;
            }
            return wave;
        }

        private static int clamp(int value, int min, int max) {
            return Math.max(min, Math.min(max, value));
        }
    }

    public static class scrollColorfulText {
        public static Component getColorfulText(String translatableText, String append, int[] colors, int step, int durationMs, boolean isTranslatable) {
            return (Component)DistExecutor.unsafeRunForDist(() -> () -> scrollColorfulText.buildGradientText(translatableText, append, colors, step, durationMs, isTranslatable), () -> () -> Component.m_237115_((String)translatableText));
        }

        private static MutableComponent buildGradientText(String textKey, @Nullable String append, int[] colors, int step, int durationMs, boolean isTranslatable) {
            String safeAppend = append != null ? append : "";
            String localizedText = isTranslatable ? Language.m_128107_().m_6834_(textKey) : textKey;
            String fullText = localizedText + safeAppend;
            int[] gradientColors = scrollColorfulText.generateLinearGradient(colors, step);
            int maxIndex = gradientColors.length - 1;
            int cycleLength = 2 * maxIndex;
            long timestamp = System.currentTimeMillis();
            MutableComponent result = Component.m_237119_();
            for (int i = 0; i < fullText.length(); ++i) {
                long timeOffset = durationMs > 0 ? timestamp / (long)durationMs : 0L;
                int progress = (int)(((long)i + timeOffset) % (long)cycleLength);
                int colorIndex = maxIndex - Math.abs(progress - maxIndex);
                if (colorIndex < 0) {
                    colorIndex = 0;
                } else if (colorIndex > maxIndex) {
                    colorIndex = maxIndex;
                }
                result.m_7220_((Component)Component.m_237113_((String)String.valueOf(fullText.charAt(i))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)gradientColors[colorIndex]))));
            }
            return result;
        }

        private static int[] generateLinearGradient(int[] colors, int totalSteps) {
            int[] gradient = new int[totalSteps];
            int segments = colors.length - 1;
            int stepsPerSegment = totalSteps / segments;
            int remainder = totalSteps % segments;
            int startIndex = 0;
            for (int i = 0; i < segments; ++i) {
                int currentSteps = stepsPerSegment;
                if (i == segments - 1) {
                    currentSteps += remainder;
                }
                int startColor = colors[i];
                int endColor = colors[i + 1];
                float r1 = startColor >> 16 & 0xFF;
                float g1 = startColor >> 8 & 0xFF;
                float b1 = startColor & 0xFF;
                float r2 = endColor >> 16 & 0xFF;
                float g2 = endColor >> 8 & 0xFF;
                float b2 = endColor & 0xFF;
                for (int j = 0; j < currentSteps; ++j) {
                    float t = (float)j / (float)(currentSteps - 1);
                    int r = (int)(r1 + (r2 - r1) * t);
                    int g = (int)(g1 + (g2 - g1) * t);
                    int b = (int)(b1 + (b2 - b1) * t);
                    int index = startIndex + j;
                    if (index >= totalSteps) continue;
                    gradient[index] = r << 16 | g << 8 | b;
                }
                startIndex += currentSteps;
            }
            return gradient;
        }
    }
}

